% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeTimeBetween.R
\name{computeTimeBetween}
\alias{computeTimeBetween}
\title{computeTimeBetween}
\usage{
computeTimeBetween(esDf, refDf, RELEVANTVN_ES = NULL,
  RELEVANTVN_REF = NULL)
}
\arguments{
\item{esDf}{a data.frame. A single ESM dataset. It must contain the 2 columns that hold the date-time object for when an ESM questionnaire was started and finished, respectively.}

\item{refDf}{a data.frame. The reference dataset.}

\item{RELEVANTVN_ES}{a list. This list is generated by function \code{\link{setES}} and it is extended once either by function \code{\link{genDateTime}} or by function \code{\link{splitDateTime}}.}

\item{RELEVANTVN_REF}{a list. This list is generated by function \code{\link{setREF}} and it is extended once either by function \code{\link{genDateTime}} or by function \code{\link{splitDateTime}}.}
}
\value{
\code{esDf} with the additional column TBESQ, i.e. the T_ime B_etween E_xperience S_ampling Q_uestionnaires.
}
\description{
computeTimeBetween computes the duration between when an ESM questionnaire was started and when the subsequent one was finished, across all ESM questionnaires per person.
}
\examples{
# o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o
# Prerequisites in order to execute computeTimeBetween. Start -------
# Use example list delivered with the package
RELEVANTVN_ES <- RELEVANTVN_ESext
# Use example list delivered with the package
RELEVANTVN_REF <- RELEVANTVN_REFext
intoleranceDf <- data.frame(prompt = c(2, 3, 4, 1, 1),
expect = c(1, 1, 1, 2, 3))
# expectedDf is a raw ESM dataset, delivered with the package.
intolLs <- intolerable(expectedDf, intoleranceDf, RELEVANTINFO_ES)
randSelLs <- randomMultSelection(intolLs[["cleanedDf"]])
# Prerequisites in order to execute computeTimeBetween. End ---------
# -------------------------------------------------------
# Run function 28 of 29; see esmprep functions' hierarchy.
# -------------------------------------------------------
# randSelLs[["esRandSelIn"]] is the result of function 'randomMultSelection'.
tbsqDf <- computeTimeBetween(randSelLs[["esRandSelIn"]], referenceDfNew, RELEVANTVN_ES,
RELEVANTVN_REF)
# o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o
}
\seealso{
Exemplary code (fully executable) in the documentation of \code{\link{esmprep}} (function 28 of 29).
}
