% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_proportion.R
\name{estimate_proportion}
\alias{estimate_proportion}
\title{Estimates for a categorical variable with no grouping (single-group design)}
\usage{
estimate_proportion(
  data = NULL,
  outcome_variable = NULL,
  cases = NULL,
  case_label = 1,
  outcome_variable_levels = NULL,
  outcome_variable_name = "My outcome variable",
  conf_level = 0.95,
  count_NA = FALSE
)
}
\arguments{
\item{data}{For raw data - a data frame or tibble}

\item{outcome_variable}{For raw data - The column name of the outcome
variable, which must be a factor, or a vector that is a factor}

\item{cases}{For summary data - A vector of cases}

\item{case_label}{A numeric or string indicating which level
of the factor to estimate.  Defaults to 1, meaning first level is analyzed}

\item{outcome_variable_levels}{For summary data - optional vector of 2
characters indicating name of the count level and name of the not count
level.  Defaults to "Affected" and "Not Affected"}

\item{outcome_variable_name}{Optional friendly name for the outcome variable.
Defaults to 'My outcome variable' or the outcome variable column name if a
data frame is passed.}

\item{conf_level}{The confidence level for the confidence interval.  Given in
decimal form.  Defaults to 0.95.}

\item{count_NA}{Logical to count NAs (TRUE) in total N or not (FALSE)}
}
\value{
Returns an object of class esci_estimate
\itemize{
\item \strong{overview}
\itemize{
\item \emph{outcome_variable_name} -
\item \emph{outcome_variable_level} -
\item \emph{cases} -
\item \emph{n} -
\item \emph{P} -
\item \emph{P_LL} -
\item \emph{P_UL} -
\item \emph{P_SE} -
\item \emph{P_adjusted} -
\item \emph{ta_LL} -
\item \emph{ta_UL} -
}
\item \strong{es_proportion}
\itemize{
\item \emph{outcome_variable_name} -
\item \emph{case_label} -
\item \emph{effect} -
\item \emph{effect_size} -
\item \emph{LL} -
\item \emph{UL} -
\item \emph{SE} -
\item \emph{effect_size_adjusted} -
\item \emph{ta_LL} -
\item \emph{ta_UL} -
\item \emph{cases} -
\item \emph{n} -
}
}
}
\description{
\code{estimate_proportion} is suitable for a single group design with a
categorical outcome variable.  It estimates the population proportion
for the frequency of each level of the outcome variable, with confidence
intervals.  You can pass raw data or summary data.
}
\details{
Once you generate an estimate with this function, you can visualize
it with \code{\link[=plot_proportion]{plot_proportion()}}.

If you want to compare your estimate to a known value or reference, then
use \code{\link[=estimate_pdiff_one]{estimate_pdiff_one()}}.

The estimated proportions are from \code{\link[statpsych:ci.prop]{statpsych::ci.prop()}} (named
ci.prop1 in statpsych < 1.6).
}
\examples{
# From raw data
data("data_campus_involvement")

estimate_from_raw <- esci::estimate_proportion(
  esci::data_campus_involvement,
  CommuterStatus
)


# To visualize the estimate
myplot_from_raw <- esci::plot_proportion(estimate_from_raw)


# From summary data
estimate_from_summary <- esci::estimate_proportion(
  cases = c(8, 22-8),
  outcome_variable_levels = c("Affected", "Not Affected")
)

# To visualize the estimate
myplot_from_summary<- esci::plot_proportion(estimate_from_summary)

}
