% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-intervals.R
\name{check_intervals}
\alias{check_intervals}
\title{Check If Each Item Is in Interval}
\usage{
check_intervals(
  x,
  valid,
  name = NULL,
  general = NULL,
  specific = NULL,
  supplement = NULL,
  ...
)
}
\arguments{
\item{x}{The argument to check.}

\item{valid}{A numeric vector of length 2, which represents the valid
closed interval. If \code{valid} is an integer vector,
\code{x} must also be an integer. \code{valid} can contain \code{NA}. For example,
\code{c(1, NA)} means \code{x} must be no less than 1.}

\item{name}{A single character which gives the argument's name.
The name is used in the error message. By default, the name of the
argument passed to argument \code{x} is captured automatically.}

\item{general}{Optional. A single character which is used to give a
general statement of the error incurred. By default, this is generated
automatically.}

\item{specific}{Optional. A single character which gives a detailed
description of the error. \code{\link[glue:glue]{glue::glue()}} syntax can be used, see
"Examples" section. By default, this is generated automatically.}

\item{supplement}{Optional. A (named) character vector which gives some
additional information about the error. The names are used to create
bullets, see \code{\link[=throw]{throw()}}. By default, this is left empty.}

\item{...}{Optional. Additional arguments which can be retrieved with
\code{\link[=tryCatch]{tryCatch()}}.}
}
\value{
returns an invisible \code{NULL} if the argument is valid, or
generates an error message.
}
\description{
Check if each item of an argument is a number in an interval,
and if not, generate an error message.
}
\examples{
x <- c(1, 3, 5)
check_intervals(x, c(0, 6))

\dontrun{
check_intervals(x, c(2, 4))
}
}
\seealso{
"Examples" section in \code{\link[=check_type]{check_type()}} for how to customize
error message and how to add and retrieve additional arguments.

\code{vignette("erify")} for a gentle introduction to this package.
}
