% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intensity-classes.R
\name{mapping}
\alias{mapping}
\alias{mapping_}
\alias{remap}
\title{Construct data mappings.}
\usage{
mapping(...)

mapping_(x)

remap(data, mapping, keep_only_std = TRUE)
}
\arguments{
\item{...}{One or more unquoted expressions separated by commas.}

\item{x}{Vector of one or more character strings.}

\item{data}{An \code{intensity} object.}

\item{mapping}{A \code{mapping} object.}

\item{keep_only_std}{Keep only standard variables.}
}
\value{
A list of mapped names.
}
\description{
Data mappings describe how variables in the data are mapped to standard names
used throughout \code{epiphy}.
}
\details{
Standard names are \code{x}, \code{y} and \code{z} for the three spatial
dimensions, and \code{t} for the time. \code{r} corresponds to the records
of (disease) intensity, and \code{n}, the number of individuals in a sampling
unit (if applicable).

\code{mapping()} works with expressions, and \code{mapping_()}, with a vector
of characters.
}
\examples{
mapping(x = col1, y = col2)
mapping_(c("x = col1", "y = col2"))

}
\seealso{
\code{\link{mapped_var}}
}
