% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Population_getters.R
\name{getEpistasis}
\alias{getEpistasis}
\title{Calculate epistatic interactions.}
\usage{
getEpistasis(pop, scale = TRUE, geno = NULL)
}
\arguments{
\item{pop}{a valid \code{Population} object with epistatic effects
attached}

\item{scale}{a boolean value indicating whether to scale the
values to bring them in line with the desired initial variance}

\item{geno}{by default, the function uses the current genotypes
in the population; alternatively, \code{geno} is a user-supplied
set of genotypes (limited to QTLs) on which to base the
calculation}
}
\description{
Calculate epistatic interactions for members of the population.
}
\details{
This function calculates the values of each epistatic interaction
per individual, returning a matrix whose rows are the individuals
in the population and whose columns are the epistatic
interactions. The sums of these rows represent the total epistatic
contribution to the phenotype, once the epistatic offset is added.
}
\examples{
# Construct a new population with epistatic effects
pop <- Population(
  popSize = 20, map = map100snp, QTL = 20,
  broadH2 = 0.4, narrowh2 = 0, traitVar = 40,
  alleleFrequencies = runif(100, 0.05, 0.5)
)
pop <- attachEpiNet(pop)

# Find the epistatic contribution to the individuals' phenotypes
rowSums(getEpistasis(pop)) + getEpiOffset(pop)

# Compare with epistatic component from getComponents()
getComponents(pop)$Epistatic
}
\seealso{
\code{\link{getEpiOffset}}
}
\author{
Dion Detterer, Paul Kwan, Cedric Gondro
}
