% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epe4md_proj_mensal.R
\encoding{UTF-8}
\name{epe4md_proj_mensal}
\alias{epe4md_proj_mensal}
\title{Faz a abertura mensal da projeção de potência}
\usage{
epe4md_proj_mensal(
  lista_potencia,
  ano_base,
  filtro_nome4md,
  filtro_de_segmento,
  ano_max_resultado = 2050,
  ajuste_ano_corrente = FALSE,
  ultimo_mes_ajuste = NA,
  metodo_ajuste = NA,
  dir_dados_premissas = "inst/dados_premissas"
)
}
\arguments{
\item{lista_potencia}{list. Resultado da função
\link{epe4md_proj_potencia}.}

\item{ano_base}{numeric. Ano base da projeção. Define o ano em que a função
irá buscar a base de dados. Último ano completo realizado.}

\item{filtro_nome4md}{string. Parâmetro que define o nome de uma concessionária
de energia a ser filtrado. Caso não seja informado um valor ou seja informado um
valor inválido o resultado será apresentado sem filtro.}

\item{filtro_de_segmento}{string. Parâmetro que define um segmento a ser
filtrado. Pode se escolher entre "comercial_at", "comercial_at_remoto",
"comercial_bt", "residencial" e "residencial_remoto".  Caso não seja
informado um valor ou seja informado um valor inválido o resultado será
apresentado sem filtro.}

\item{ano_max_resultado}{numeric. Ano final para apresentação dos resultados.
Máximo igual a 2050. Default igual a 2050.}

\item{ajuste_ano_corrente}{logic. Se TRUE indica que a projeção deverá
incorporar o histórico mensal recente, verificado em parte do primeiro ano
após o ano base. Default igual a FALSE. O arquivo base_mmgd.xlsx deve
incorporar esse histórico.}

\item{ultimo_mes_ajuste}{numeric. Último mês com dados completos na
base_ano_corrente. Default igual a NA. Só tem efeito caso ajuste_ano_corrente
seja igual a TRUE.}

\item{metodo_ajuste}{string. Se igual a "extrapola" o modelo irá extrapolar a
potência e o número de adotantes até o final do ano base + 1 com base no
verificado até o ultimo_mes_ajuste. Se igual a "substitui", o modelo
substitui a projeção até o ultimo_mes_ajuste e mantém o restante do ano com a
projeção normal. Só tem efeito caso ajuste_ano_corrente seja igual a TRUE.}

\item{dir_dados_premissas}{Diretório onde se encontram as premissas.
Se esse parâmetro não for passado, a função usa os dados default que são
instalados com o pacote. É importante que os nomes dos arquivos sejam os
mesmos da pasta default.}
}
\value{
data.frame com os resultados da projeção de capacidade instalada
de micro e minigeração distribuída e número de adotantes mensal
}
\description{
Faz a abertura mensal da projeção de potência
}
\examples{
lista_potencia <- list(
 proj_potencia = structure(
   list(nome_4md = c("RORAIMA", "RORAIMA", "RORAIMA", "RORAIMA", "RORAIMA"),
        segmento = c("comercial_at", "comercial_at", "comercial_at",
        "comercial_at", "comercial_at"),
        p = c(0.000122298434419402, 0.000122298434419402,
        0.000122298434419402, 0.000122298434419402, 0.000122298434419402),
        q = c(1, 1, 1, 1, 1),
        spb = c(0.3, 0.3, 0.3, 0.3, 0.3),
        ano = c(2017, 2018, 2019, 2020, 2021),
        Ft = c(0.0177177153816275, 0.0469352065606947, 0.118237854106428,
        0.267268529395706, 0.497952210651889),
        consumidores = c(656, 678, 751, 764, 791),
        payback = c(25, 12.9151902647661, 7.76175962915069,
        11.9207871041042, 11.8969973448089),
        mercado_potencial = c(0.25, 3.5, 18.25, 5.25, 5.5),
        adotantes_ano = c(3, 1, 1, 3, 6),
        adotantes_acum = c(3, 4, 5, 8, 14),
        fonte_resumo = c("Fotovoltaica", "Fotovoltaica", "Fotovoltaica",
        "Fotovoltaica", "Fotovoltaica"),
        part_fonte = c(1, 1, 1, 1, 1),
        adotantes_hist = c(3, 1, 1, 3, 6),
        pot_media = c(353.694375, 353.694375, 353.694375, 353.694375,
        353.694375),
        pot_ano = c(199, 80, 94, 4602, 529.11),
        pot_hist = c(199, 80, 94, 4602, 529.11),
        pot_ano_mw = c(0.199, 0.08, 0.094, 4.602, 0.52911),
        pot_acum_mw = c(0.199, 0.279, 0.373, 4.975, 5.50411)),
   class = c("tbl_df", "tbl", "data.frame"),
   row.names = c(NA, -5L)
 ),
 part_adotantes = structure(
   list(ano = c(2017, 2018, 2019, 2020, 2021),
        segmento = c("comercial_at", "comercial_at", "comercial_at",
        "comercial_at", "comercial_at"),
        adotantes = c(3, 4, 5, 8, 14),
        mercado_potencial = c(1, 14, 73, 21, 22),
        total_ucs = c(187922, 187853, 184276, 182048, 181394),
        penetracao_total = c(1.5964070199338e-05, 2.12932452502755e-05,
        2.71332132236428e-05, 4.39444542098787e-05, 7.71800610825055e-05),
        mercado_nicho = c(187922, 187853, 184276, 182048, 181394),
        penetracao_nicho = c(1.5964070199338e-05, 2.12932452502755e-05,
        2.71332132236428e-05, 4.39444542098787e-05, 7.71800610825055e-05),
        penetracao_potencial = c(3, 0.285714285714286, 0.0684931506849315,
        0.380952380952381, 0.636363636363636)),
   row.names = c(NA, -5L),
   class = c("tbl_df", "tbl", "data.frame")
 )
)

proj_mensal <- epe4md_proj_mensal(
 lista_potencia = lista_potencia,
 ano_base = 2021,
 filtro_nome4md = "RORAIMA",
 filtro_de_segmento = "comercial_at",
 ano_max_resultado = 2021
)
}
