% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipos.R
\name{get_ipos}
\alias{get_ipos}
\title{Retrieves IPO (Initial Public Offering) data for a given time period}
\usage{
get_ipos(
  first_date = Sys.Date() - 3 * 365,
  last_date = Sys.Date(),
  cache_folder = get_default_cache(),
  check_quota = TRUE
)
}
\arguments{
\item{first_date}{the first date to fetch ipos information. Default is previous
three years}

\item{last_date}{the last date to fetch news. Default is today.}

\item{cache_folder}{A local directory to store cache files. By default, all functions use a temporary path, meaning that the caching system
is session persistent (it will remove all files when you exit your R session). If you want a persistent caching system, simply point argument
cache_folder to a local directory in your filesystem. Be aware, however, that a persistent cache will not refresh your data for new api queries.}

\item{check_quota}{A flag (TRUE/FALSE) for whether to check the current quota status from the api. This option implies a small cost of execution
time. If you need speed, just set it to FALSE.}
}
\value{
A dataframe with news events and sentiments
}
\description{
This function will query the IPO end point of eodhd and return all ipos for a user
supplied time period.
}
\examples{
\dontrun{
set_token("YOUR_VALID_TOKEN")
df_news <- get_ipos()
}
}
