% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HMDClasses.R
\docType{class}
\name{LT1-class}
\alias{LT1-class}
\alias{header,LT1-method}
\alias{lt1,LT1-method}
\alias{content,LT1-method}
\alias{region,LT1-method}
\alias{protocol,LT1-method}
\alias{LTable1}
\alias{length,LT1-method}
\alias{show,LT1-method}
\alias{selectYears,LT1-method}
\alias{readLT1x1}
\title{LT1 class for HMD life-tables 1x1}
\usage{
\S4method{header}{LT1}(object)

\S4method{lt1}{LT1}(object)

\S4method{content}{LT1}(object)

\S4method{region}{LT1}(object)

\S4method{protocol}{LT1}(object)

LTable1(header, lt1, content, region, protocol)

\S4method{length}{LT1}(x)

\S4method{show}{LT1}(object)

\S4method{selectYears}{LT1}(object, selectYears)

readLT1x1(infile)
}
\arguments{
\item{object}{LT1-object}

\item{header}{vector}

\item{lt1}{data.table}

\item{content}{character}

\item{region}{character}

\item{protocol}{character}

\item{x}{LT1-object}

\item{selectYears}{vector}

\item{infile}{character file name}
}
\value{
The \code{header}-method returns the raw header information

The \code{lt1}-method returns the life-table

The \code{content}-method returns the content information

The \code{region}-method returns the regional information

The \code{protocol}-method returns the protocol information

The \code{LTable1}-constructor returns an LT1 object

The \code{length}-method returns the number of rows

The \code{selectYears}-method returns an LT1 object

The \code{readLT1x1}-method returns an LT1 object
}
\description{
The class \code{LT1} stores HMD life table information in a systematic way.

The \code{header}-method gets the raw header information of an LT1 object

The \code{lt1}-method gets the life table information of an LT1 object

The \code{content}-method gets the life table information of an LT1 object

The \code{region}-method gets the regional information of an LT1 object

The \code{protocol}-method gets the protocol information of an LT1 object

The \code{LTable1}-constructor creates an LT1 object

The \code{length}-method gets the number of rows int the LT1 lt1 data.table

The \code{selectYears}-method gets a subset of an LT1 object

The \code{readLT1x1}-method reads all information from the file 1x1 period life table
}
\details{
This \code{LT1} class fits to Human Mortality Database (HMD) 1x1 period life tables.
See https://www.mortality.org/ for data details.
An LT1 instance stores the raw header, the content, 
the version protocol and regional information and the
life table as a data.table object.
The validation adds a pure numeric age AgeLow to the life table.
Try demo(LT1) for a demonstration.
}
\section{Slots}{

\describe{
\item{\code{content}}{describes the content}

\item{\code{region}}{regional entity}

\item{\code{header}}{includes the raw header information}

\item{\code{lt1}}{stores the life table (data.table)}

\item{\code{protocol}}{contains the protocol information}
}}

\examples{
o1 <- readLT1x1(file.path(system.file(package="eoR"), "extdata", "DEUTNP.fltper_1x1m.txt"))
header(o1)
lt1(o1)[, table(Year)]
}
