% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extremevalue.R
\name{extremal.index.sliding.blocks}
\alias{extremal.index.sliding.blocks}
\title{Extremal index estimation (Northrop, 2015) - Only intended for developer use}
\usage{
extremal.index.sliding.blocks(x, b = round(sqrt(length(x))))
}
\arguments{
\item{x}{a numeric vector of observations.}

\item{b}{a numeric value giving the length of blocks. Default is \code{b = round(sqrt(n))}.}
}
\value{
a numeric value of an extremal index estimate
}
\description{
Estimation of an extremal index using the sliding blocks estimator suggested in (Northrop, 2015).
The function is called by \code{\link{KRDetect.outliers.EV}} and is not intended for use by regular users of the package.
}
\details{
This function computes the sliding blocks estimate of extremal index suggested in (Northrop, 2015).
The function is exported for developer use only. It does not perform any checks on inputs since it is only convenience function used within \code{\link{KRDetect.outliers.EV}}.
}
\references{
Northrop, PJ (2015). An Efficient Semiparametric Maxima Estimator of the Extremal Index. Extremes, 18, 585-603.
}
