% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thermicityIndex.R
\name{thermicityIndex}
\alias{thermicityIndex}
\title{Compensated Thermicity index}
\usage{
thermicityIndex(
  annualTemp,
  minTemp,
  maxTemp,
  continentality,
  returnCompensated = TRUE,
  tempScale = 1
)
}
\arguments{
\item{annualTemp}{rasterLayer, mean annual temperature}

\item{minTemp}{rasterLayer, min temp of the coldest month}

\item{maxTemp}{rasterLayer, max temp of the coldest month}

\item{continentality}{rasterLayer, continentality index}

\item{returnCompensated}{logical: if \code{FALSE}, regular thermicity index is returned.}

\item{tempScale}{integer; scaling factor for the temperature data, see \link{envirem} for 
additional details.}
}
\value{
rasterLayer in degrees C
}
\description{
Compensated Thermicity index
}
\details{
thermicity index = tempRange + minTemp + maxTemp

The compensated thermicity index incorporates corrections designed to make this metric
more appropriately comparable across the globe.
}
\examples{
\donttest{
# Find example rasters
rasterFiles <- list.files(system.file('extdata', package='envirem'), full.names=TRUE)
env <- rast(rasterFiles)

# identify appropriate layers
tmean <- grep('tmean', names(env))
tmin <- grep('tmin', names(env))
tmax <- grep('tmax', names(env))

tmean <- env[[tmean]]
tmin <- env[[tmin]]
tmax <- env[[tmax]]

# calculate temperature extremes
temp <- otherTempExtremes(tmean, tmin, tmax)

ci <- continentality(temp[['meanTempWarmest']], temp[['meanTempColdest']], tempScale = 10)

# compensated thermicity index
thermicityIndex(env[['bio_1']], env[['bio_6']], temp[['maxTempColdest']], ci, tempScale = 10)
}
}
\references{
Rivas-Martínez, S. & Rivas-Sáenz, S. “Synoptical Worldwide Bioclimatic 
Classification System”. [accessed 15 February 2016]

Sayre, R., Comer, P., Warner, H. & Cress, J. (2009) \emph{A new map of standardized
terrestrial ecosystems of the conterminous United States: US Geological Survey 
Professional Paper 1768}. Reston, VA.
}
\seealso{
\link{continentality}
}
\author{
Pascal Title
}
