% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canada.r
\docType{data}
\name{canada}
\alias{canada}
\title{Vector outline of Canada}
\format{
An object of class \code{'SpatVector'}.
}
\source{
\href{https://gadm.org/index.html}{Database of Global Administrative Areas (GADM)}
}
\description{
This \code{SpatVector} represents the outline of Canada in WGS84 (unprojected) coordinates. This is the "low resolution" (less accurate) version from GADM.
}
\examples{

library(terra)
canFile <- system.file('extdata', 'canada_level0_gadm41.gpkg', package='enmSdmX')
canada <- vect(canFile)
plot(canada)

}
\keyword{Canada}
