% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{ecf_mod}
\alias{ecf_mod}
\title{Modulus of empirical characteristic function}
\usage{
ecf_mod(t, smp)
}
\arguments{
\item{t}{m x d matrix where the function will be evaluated.}

\item{smp}{n x d matrix with sample size if size n.}
}
\value{
A vector of size m with the modulus of the empirical
characteristic function.
}
\description{
Modulus of empirical characteristic function of a d-dimensional
random variable. This function is evaluated at m vectors of size
d.
}
\details{
This function must receive matrices or vectors. It is a wrapper
function that allows more general inputs.
}
\examples{
library(empichar)
t <- seq(-10, 10, 0.05)
X <- rnorm(150)
vals <- ecf_mod(t, X)
plot(t, vals, type = "l")

}
