% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatting.R
\name{colorize}
\alias{colorize}
\title{Colorize Text for Knitted Documents}
\usage{
colorize(x, color)
}
\arguments{
\item{x}{Character string to colorize}

\item{color}{Character string specifying the color name (e.g., "red", "blue")}
}
\value{
Character string wrapped in LaTeX or HTML color commands, or
unchanged if output format is neither
}
\description{
Wraps text in color formatting appropriate for the output format (LaTeX or HTML).
This function is intended for use within R Markdown/knitr documents.
}
\details{
This function detects the knitr output format and applies appropriate color
formatting. For LaTeX output, it uses \verb{\\\\textcolor\{\}}. For HTML output, it
uses \verb{<span style='color: ...'>}.
}
\examples{
\donttest{
# In an R Markdown document:
colorize("Important text", "red")
}
}
