% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/provider-mistral.R
\name{chat_mistral}
\alias{chat_mistral}
\alias{models_mistral}
\title{Chat with a model hosted on Mistral's La Platforme}
\usage{
chat_mistral(
  system_prompt = NULL,
  params = NULL,
  api_key = NULL,
  credentials = NULL,
  model = NULL,
  api_args = list(),
  echo = NULL,
  api_headers = character()
)

models_mistral(api_key = mistral_key())
}
\arguments{
\item{system_prompt}{A system prompt to set the behavior of the assistant.}

\item{params}{Common model parameters, usually created by \code{\link[=params]{params()}}.}

\item{api_key}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use \code{credentials} instead.}

\item{credentials}{Override the default credentials. You generally should not need this argument; instead set the \code{MISTRAL_API_KEY} environment variable. The best place to set this is in \code{.Renviron},
which you can easily edit by calling \code{usethis::edit_r_environ()}.

If you do need additional control, this argument takes a zero-argument function that returns either a string (the API key), or a named list (added as additional headers to every request).}

\item{model}{The model to use for the chat (defaults to "mistral-large-latest").
We regularly update the default, so we strongly recommend explicitly specifying a model for anything other than casual use.}

\item{api_args}{Named list of arbitrary extra arguments appended to the body
of every chat API call. Combined with the body object generated by ellmer
with \code{\link[=modifyList]{modifyList()}}.}

\item{echo}{One of the following options:
\itemize{
\item \code{none}: don't emit any output (default when running in a function).
\item \code{output}: echo text and tool-calling output as it streams in (default
when running at the console).
\item \code{all}: echo all input and output.
}

Note this only affects the \code{chat()} method.}

\item{api_headers}{Named character vector of arbitrary extra headers appended
to every chat API call.}
}
\value{
A \link{Chat} object.
}
\description{
Get your API key from \url{https://console.mistral.ai/api-keys}.

Built on top of \code{\link[=chat_openai_compatible]{chat_openai_compatible()}}.
\subsection{Known limitations}{
\itemize{
\item Tool calling is unstable.
\item Images require a model that supports images.
}
}
}
\examples{
\dontrun{
chat <- chat_mistral()
chat$chat("Tell me three jokes about statisticians")
}
}
\seealso{
Other chatbots: 
\code{\link{chat_anthropic}()},
\code{\link{chat_aws_bedrock}()},
\code{\link{chat_azure_openai}()},
\code{\link{chat_cloudflare}()},
\code{\link{chat_databricks}()},
\code{\link{chat_deepseek}()},
\code{\link{chat_github}()},
\code{\link{chat_google_gemini}()},
\code{\link{chat_groq}()},
\code{\link{chat_huggingface}()},
\code{\link{chat_ollama}()},
\code{\link{chat_openai}()},
\code{\link{chat_openai_compatible}()},
\code{\link{chat_openrouter}()},
\code{\link{chat_perplexity}()},
\code{\link{chat_portkey}()}
}
\concept{chatbots}
