% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{utilities}
\alias{utilities}
\alias{calc_rit}
\alias{calc_rbar}
\alias{calc_alpha}
\alias{rvrs_var}
\alias{rvrs_note}
\alias{extr_core}
\alias{extr_core_nms}
\alias{extreb_itms}
\alias{nme_msdf}
\title{Miscellaneous utility functions}
\usage{
calc_rit(scl, use)

calc_rbar(scl, use)

calc_alpha(scl, use)

rvrs_var(var, sclvals)

rvrs_note(msg, applicant)

extr_core(scl)

extr_core_nms(scl)

extreb_itms(df, itm_nms)

nme_msdf(x)
}
\arguments{
\item{scl}{a scale within a multiple scaled data frame.}

\item{use}{an optional string indicating how to deal with missing values, See
\code{use} in \code{\link[stats]{cor}} for details.}

\item{var}{a variable or item (often a column from a data frame).}

\item{sclvals}{the start- and end point of a scale (specify:
\code{c(sp,ep)}).}

\item{msg}{a reverse message sent from either \code{disjoint()} or
\code{overlap()}.}

\item{applicant}{the function which wants to leave messages \code{disjoint()}
or \code{overlap()}.}

\item{df}{a data frame object.}

\item{itm_nms}{the names of an item from a scale.}

\item{x}{a multiple scaled data frame.}
}
\value{
\code{calc_rit()} returns a numeric vector of length one. It is used
  to examine the coherence between item and overall score.

\code{calc_rbar()} returns a numeric vector of length one that
  reports the inter-item correlation.

\code{calc_alpha()} returns a numeric vector of length one which is
  used to assess the internal consistency of a scale.

\code{rvrs_var()} returns the reversed numeric vector using the above
  reversing scheme.

\code{rvrs_note()} is called for its side effects. It leaves a
  message when an item is reversed.

\code{extr_core()} returns a numeric vector of length two, which
  contains the two items with the highest correlation in a fragment or scale.

\code{extr_core_nms()} returns character vector of length two, which
  contains the names of the two items with the highest correlation in a
  fragment or scale.

\code{extrev_itms()} returns vector of length m minus two, where 'm'
  specifies the number of variables in a given data set. It contains the
  items of a scale's counterpart.

\code{nme_msdf()} returns a character vector that numbers each
  element of its input according to the above naming scheme.
}
\description{
A set of utility functions to calculate characteristic values of
  classical test theory, reverse a variable, and extract the relevant bits
  from various objects.

\code{calc_rit()} calculates the corrected item-total
  correlation of a scale or fragment using a part-whole correction. Thus, the
  item itself is excluded in the calculation process.

\code{calc_rbar()} calculates the average correlation of a
  fragment or scale.

\code{calc_alpha()} calculates the internal consistency of a
scale or fragment using Cronbach's alpha.

\code{rvrs_var()} reverses an item using the specified scaling values. It
  handles the following types of scales:
  \itemize{
  \item  ...-3 -2 -1 0 1 2 3..., e.g., \code{sclvals = c(-3, 3)}
  \item  0 1 2 3 4 5 6..., e.g.,  \code{sclvals = c(0, 7)}
  \item  1 2 3 4 5 6 7..., e.g., \code{sclcals = c(1, 7)}
  }

\code{rvrs_note()} gets the full report of reversed variables
  and reports a unique list of them.

\code{extr_core()} is used to extract all pairs of core items from a
  fragment.

\code{extr_core_nms()} is used to extract the names of all pairs
  of core items from a given fragment.

\code{extreb_itms()} builds the counterpart of a fragment from
  the given item names. Therefore, the counterpart includes all variables
  that are not part of a fragment but which are mentioned in the specified
  data set.

\code{nme_msdf()} renames the components of a multiple scaled
  data frame. The naming scheme is \code{scl_n}. \code{scl} stands for
  `scale` and \code{n} specifies the number of fragments or scales. For
  example, the first component is called \code{scl_1}.
}
\details{
All functions are internal functions.
}
