% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_funs.R
\name{ivlev_electivity}
\alias{ivlev_electivity}
\title{Ivlev's electivity, E}
\usage{
ivlev_electivity(r, p)
}
\arguments{
\item{r}{(Numeric) Resource utilisation.}

\item{p}{(Numeric) Resource availability.}
}
\value{
A numeric vector.
}
\description{
Bounded between -1.0 (avoidance), 0 (random feeding), and +1.0 (preference).
}
\section{Source}{

Lechowicz, M.J., 1982. The sampling characteristics of electivity indices.
Oecologia 52, 22–30. https://doi.org/10.1007/BF00349007
}

\examples{
data(moth_distrib)
ivlev_electivity(moth_distrib$r, moth_distrib$p)

}
