% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legend_local.R
\name{legend_local}
\alias{legend_local}
\title{Download data on local election coalitions in Brazil}
\usage{
legend_local(year, uf = "all", encoding = "latin1", temp = TRUE)
}
\arguments{
\item{year}{Election year. For this function, only the years  2008, 2012, 2016, 2020, and 2024
are available.}

\item{uf}{Federation Unit acronym (\code{character vector}).}

\item{encoding}{Data original encoding (defaults to 'Latin-1'). This can be changed to avoid errors
when \code{ascii = TRUE}.}

\item{temp}{(\code{logical}). If \code{TRUE}, keep the temporary compressed file for future use (recommended)}
}
\value{
\code{legend_local()} returns a \code{data.frame}.
}
\description{
\code{legend_local()} downloads and aggregates the party denominations (coalitions or parties) from the local elections in Brazil,
disaggregated by cities. The function returns a \code{data.frame} where each observation
corresponds to a city.
}
\details{
If export is set to \code{TRUE}, the downloaded data is saved as .dta and .sav
 files in the current directory.
}
\examples{
\dontrun{
df <- legend_local(2000)
}
}
