% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2_semipartial.R
\name{r2_semipartial}
\alias{r2_semipartial}
\alias{r2_delta}
\alias{r2_part}
\title{Semi-Partial (Part) Correlation Squared (\eqn{\Delta R^2})}
\usage{
r2_semipartial(
  model,
  type = c("terms", "parameters"),
  ci = 0.95,
  alternative = "greater",
  ...
)
}
\arguments{
\item{model}{An \code{lm} model.}

\item{type}{Type, either \code{"terms"}, or \code{"parameters"}.}

\item{ci}{Confidence Interval (CI) level}

\item{alternative}{a character string specifying the alternative hypothesis;
Controls the type of CI returned: \code{"greater"} (default) or \code{"less"}
(one-sided CI), or \code{"two.sided"} (two-sided CI). Partial matching is
allowed (e.g., \code{"g"}, \code{"l"}, \code{"two"}...). See \emph{One-Sided CIs} in
\link{effectsize_CIs}.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A data frame with the effect size.
}
\description{
Compute the semi-partial (part) correlation squared (also known as
\eqn{\Delta R^2}). Currently, only \code{lm()} models are supported.
}
\details{
This is similar to the last column of the "Conditional Dominance Statistics"
section of the \code{\link[parameters:dominance_analysis]{parameters::dominance_analysis()}} output. For each term, the
model is refit \emph{without} the columns on the \link[stats:model.matrix]{model matrix} that correspond to that term. The \eqn{R^2} of
this \emph{sub}-model is then subtracted from the \eqn{R^2} of the \emph{full} model to
yield the \eqn{\Delta R^2}. (For \code{type = "parameters"}, this is done for each
column in the model matrix.)

\strong{Note} that this is unlike \code{\link[parameters:dominance_analysis]{parameters::dominance_analysis()}}, where term
deletion is done via the formula interface, and therefore may lead to
different results.

For other, non-\code{lm()} models, as well as more verbose information and
options, please see the documentation for \code{\link[parameters:dominance_analysis]{parameters::dominance_analysis()}}.
}
\section{Confidence (Compatibility) Intervals (CIs)}{
Confidence intervals are based on the normal approximation as provided by Alf
and Graf (1999). An adjustment to the lower bound of the CI is used, to
improve the coverage properties of the CIs, according to Algina et al (2008):
If the \emph{F} test associated with the \eqn{sr^2} is significant (at \code{1-ci}
level), but the lower bound of the CI is 0, it is set to a small value
(arbitrarily to a 10th of the estimated \eqn{sr^2}); if the \emph{F} test is not
significant, the lower bound is set to 0. (Additionally, lower and upper
bound are "fixed" so that they cannot be smaller than 0 or larger than 1.)
}

\section{CIs and Significance Tests}{
"Confidence intervals on measures of effect size convey all the information
in a hypothesis test, and more." (Steiger, 2004). Confidence (compatibility)
intervals and p values are complementary summaries of parameter uncertainty
given the observed data. A dichotomous hypothesis test could be performed
with either a CI or a p value. The 100 (1 - \eqn{\alpha})\% confidence
interval contains all of the parameter values for which \emph{p} > \eqn{\alpha}
for the current data and model. For example, a 95\% confidence interval
contains all of the values for which p > .05.
\cr\cr
Note that a confidence interval including 0 \emph{does not} indicate that the null
(no effect) is true. Rather, it suggests that the observed data together with
the model and its assumptions combined do not provided clear evidence against
a parameter value of 0 (same as with any other value in the interval), with
the level of this evidence defined by the chosen \eqn{\alpha} level (Rafi &
Greenland, 2020; Schweder & Hjort, 2016; Xie & Singh, 2013). To infer no
effect, additional judgments about what parameter values are "close enough"
to 0 to be negligible are needed ("equivalence testing"; Bauer & Kiesser,
1996).
}

\section{Plotting with \code{see}}{

The \code{see} package contains relevant plotting functions. See the \href{https://easystats.github.io/see/articles/effectsize.html}{plotting vignette in the \code{see} package}.
}

\examples{
data("hardlyworking")

m <- lm(salary ~ factor(n_comps) + xtra_hours * seniority, data = hardlyworking)

r2_semipartial(m)

r2_semipartial(m, type = "parameters")



# Compare to `eta_squared()`
# --------------------------
npk.aov <- lm(yield ~ N + P + K, npk)

# When predictors are orthogonal,
# eta_squared(partial = FALSE) gives the same effect size:
performance::check_collinearity(npk.aov)

eta_squared(npk.aov, partial = FALSE)

r2_semipartial(npk.aov)

\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Compare to `dominance_analysis()`
# ---------------------------------
m_full <- lm(salary ~ ., data = hardlyworking)

r2_semipartial(m_full)

# Compare to last column of "Conditional Dominance Statistics":
parameters::dominance_analysis(m_full)
\dontshow{\}) # examplesIf}
}
\references{
\itemize{
\item Alf Jr, E. F., & Graf, R. G. (1999). Asymptotic confidence limits for the
difference between two squared multiple correlations: A simplified approach.
\emph{Psychological Methods, 4}(1), 70-75. \doi{10.1037/1082-989X.4.1.70}
\item Algina, J., Keselman, H. J., & Penfield, R. D. (2008). Confidence intervals
for the squared multiple semipartial correlation coefficient. \emph{Journal of
Modern Applied Statistical Methods, 7}(1), 2-10. \doi{10.22237/jmasm/1209614460}
}
}
\seealso{
\code{\link[=eta_squared]{eta_squared()}}, \code{\link[=cohens_f]{cohens_f()}} for comparing two models,
\code{\link[parameters:dominance_analysis]{parameters::dominance_analysis()}} and
\code{\link[parameters:standardize_parameters]{parameters::standardize_parameters()}}.
}
