% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docs_extra.R, R/eta_squared-main.R
\name{effectsize_API}
\alias{effectsize_API}
\alias{.es_aov_simple}
\alias{.es_aov_strata}
\alias{.es_aov_table}
\title{\code{effectsize} API}
\usage{
.es_aov_simple(
  aov_table,
  type = c("eta", "omega", "epsilon"),
  partial = TRUE,
  generalized = FALSE,
  include_intercept = FALSE,
  ci = 0.95,
  alternative = "greater",
  verbose = TRUE
)

.es_aov_strata(
  aov_table,
  DV_names,
  type = c("eta", "omega", "epsilon"),
  partial = TRUE,
  generalized = FALSE,
  include_intercept = FALSE,
  ci = 0.95,
  alternative = "greater",
  verbose = TRUE
)

.es_aov_table(
  aov_table,
  type = c("eta", "omega", "epsilon"),
  partial = TRUE,
  generalized = FALSE,
  include_intercept = FALSE,
  ci = 0.95,
  alternative = "greater",
  verbose = TRUE
)
}
\arguments{
\item{aov_table}{Input data frame}

\item{type}{Which effect size to compute?}

\item{partial, generalized, ci, alternative, verbose}{See \code{\link[=eta_squared]{eta_squared()}}.}

\item{include_intercept}{Should the intercept (\code{(Intercept)}) be included?}

\item{DV_names}{A character vector with the names of all the predictors,
including the grouping variable (e.g., \code{"Subject"}).}
}
\description{
Read the \href{https://easystats.github.io/effectsize/articles/effectsize_API.html}{\emph{Support functions for model extensions}} vignette.
}
