% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{list_variables}
\alias{list_variables}
\title{List available variables in the education finance dataset}
\usage{
list_variables(dataset_type = "skinny", category = "all")
}
\arguments{
\item{dataset_type}{A string specifying whether to list variables for "skinny" (default) or "full" dataset.}

\item{category}{Optional. Filter variables by category: "id", "time", "geographic", 
"demographic", "revenue", "expenditure", "economic", "governance", 
or "all" (default).}
}
\value{
A tibble with variable information
}
\description{
This function provides information about the variables available
in the education finance dataset, including their names, types,
and brief descriptions.
}
\examples{
# list all available variables in skinny dataset
vars <- list_variables()
head(vars)

# list all variables in full dataset
full_vars <- list_variables(dataset_type = "full")
nrow(full_vars)

# list only expenditure variables in full dataset
exp_vars <- list_variables(dataset_type = "full", category = "expenditure")
head(exp_vars)
}
