% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_finance_data.R
\name{get_finance_data}
\alias{get_finance_data}
\title{Get Education Finance Data}
\usage{
get_finance_data(
  yr = "2022",
  geo = "all",
  dataset_type = "skinny",
  cpi_adj = "none",
  refresh = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{yr}{A string specifying the year(s) to retrieve. Can be a single year ("2022"),
a range ("2020:2022"), or "all" for all available years. Defaults to "2022".}

\item{geo}{A string specifying the geographic scope. Can be "all" for all states (default),
a single state code ("KY"), or a comma-separated list of state codes ("IN,KY,OH,TN").}

\item{dataset_type}{A string specifying whether to download the "skinny" (default) or "full" dataset.
The skinny version excludes detailed expenditure data for faster downloads.}

\item{cpi_adj}{A string specifying the CPI adjustment baseline year. Can be "none" (default) 
for no adjustment, or a year between 2012-2022 to use as the baseline year.
When a year is specified (e.g., "2022"), revenue, expenditure, and economic 
variables are adjusted to that school year's dollars using CPI averaged over 
the months of the school year (e.g., "2022" uses the 2021-22 school year CPI).
When cpi_adj is set to a value other than "none", a new column "cpi_adj_index" 
will be added to the output showing the adjustment index used for each row.}

\item{refresh}{A logical value indicating whether to force a refresh of the cached data. Default is FALSE.}

\item{quiet}{A logical value indicating whether to suppress download progress messages.
Default is FALSE. Note: Cache is stored in R's temporary directory and will be cleared when 
the R session ends.}
}
\value{
A tibble containing the requested education finance data.
}
\description{
This function downloads tidy education finance data using data from the
NCES F-33 Survey, Census Bureau Small Area Income Poverty Estimates (SAIPE),
and community data from the ACS 5-Year Estimates.
}
\examples{
# Check valid parameters without downloading
get_states()  # Valid state codes

\donttest{
# These examples require internet access and may take time to download

# get data for Kentucky for 2022
ky_data <- get_finance_data(yr = "2022", geo = "KY")

# get data for multiple years
ky_multi <- get_finance_data(yr = "2020:2022", geo = "KY")

# get full dataset with detailed expenditure data
ky_full <- get_finance_data(yr = "2022", geo = "KY", dataset_type = "full")
  
# get data adjusted to 2022 dollars
ky_adjusted <- get_finance_data(yr = "2020:2022", geo = "KY", cpi_adj = "2022")

#' # get data for multiple states for all available years
regional_data <- get_finance_data(yr = "all", geo = "IN,KY,OH,TN")
}
}
