% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_gg.R
\name{ggtpp}
\alias{ggtpp}
\title{Time-profile plot wrapper}
\usage{
ggtpp(
  d,
  x,
  y,
  id,
  ...,
  nsub = TRUE,
  logx = FALSE,
  logy = FALSE,
  alpha_point = 0.2,
  alpha_line = 0.1,
  xlab = NULL,
  ylab = NULL,
  ttl = NULL,
  sttl = NULL,
  cap = NULL
)
}
\arguments{
\item{d}{\verb{<dfr>} A data frame.}

\item{x, y}{\verb{<var>} Variables for x- and y-axis as unquoted names}

\item{id}{\verb{<var>} Variable for grouping ID such as subject ID as unquoted name.}

\item{...}{Arguments to pass to \link[ggplot2:aes]{ggplot2::aes} for additional mapping.}

\item{nsub}{\verb{<lgl>} \code{TRUE} to show number of subjects as per \code{id} in caption.}

\item{logx, logy}{\verb{<lgl>} \code{TRUE} to log x- and y-axis.}

\item{alpha_point}{\verb{<num>} Alpha value for \link[ggplot2:geom_point]{ggplot2::geom_point}.}

\item{alpha_line}{\verb{<num>} Alpha value for \link[ggplot2:geom_path]{ggplot2::geom_line}.}

\item{xlab, ylab}{\verb{<chr>} Labels for x- and y-axis.}

\item{ttl, sttl, cap}{\verb{<chr>} Title. Subtitle. Caption.}
}
\value{
A ggplot object.
}
\description{
Create plots for time profile data such as PK and PD plots.
}
\examples{
Theoph |> ggtpp(x=Time,y=conc,id=Subject)
}
