% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PA.EMOA.makeEMOAIndicator.R
\name{makeEMOAIndicator}
\alias{makeEMOAIndicator}
\title{Constructor for EMOA indicators.}
\usage{
makeEMOAIndicator(fun, minimize, name, latex.name)
}
\arguments{
\item{fun}{[\code{function(points, ...)}]\cr
Function which expects a numeric matrix \dQuote{points} as first argument.
Optional named arguments (often \dQuote{ref.point} for a reference
point or \dQuote{ref.points} for a reference set, e.g., the true Pareto-front)
are allowed. See implementations of existing indicators for examples.}

\item{minimize}{[\code{logical(1)}]\cr
Lower values indicate better performance?}

\item{name}{[\code{character(1)}]\cr
Short name of the indicator. Used, e.g., as column name for the indicator
in the data.frame returned by \code{\link{computeIndicators}}.}

\item{latex.name}{[\code{character(1)}]\cr
LaTeX representation of the indicator. Used in LaTeX-table output statistical
tests (see \code{\link{toLatex}}).}
}
\value{
[\code{function(points, ...)}] Argument \code{fun} with all other
  arguments appended.
}
\description{
Simple wrapper for function which compute
performance indicators for multi-objective stochastic algorithm.
Basically this function appends some meta information to the
passed function \code{fun}.
}
\seealso{
Other EMOA performance assessment tools: 
\code{\link{approximateNadirPoint}()},
\code{\link{approximateRefPoints}()},
\code{\link{approximateRefSets}()},
\code{\link{computeDominanceRanking}()},
\code{\link{emoaIndEps}()},
\code{\link{niceCellFormater}()},
\code{\link{normalize}()},
\code{\link{plotDistribution}()},
\code{\link{plotFront}()},
\code{\link{plotScatter2d}()},
\code{\link{plotScatter3d}()},
\code{\link{toLatex}()}
}
\concept{EMOA performance assessment tools}
