% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shape_ecp.R
\name{ecp_shape}
\alias{ecp_shape}
\title{Bowley skewness and Moors kurtosis}
\usage{
ecp_shape(lambda, gamma, phi, measure)
}
\arguments{
\item{lambda, gamma}{parameter values > 0.}

\item{phi}{parameter value != 0.}

\item{measure}{Specifies the type of measure to be computed. Possible
types are:

 - 'bowley' for Bowley skewness,
 - 'moors' for Moors kurtosis.}
}
\value{
Numeric value of the Bowley skewness or the Moors kurtosis.
}
\description{
Computes robust skewness and kurtosis measures based on quantile function of
the extended Chen-Poisson (ecp) distribution.
}
\details{
The Extended Chen-Poisson distribution has no closed-form expression
for the moments. Therefore, the classical measures of
skewness and kurtosis based on moments are intractable. In such cases,
quantile-based measures are often considered, namely the Bowley skewness and
Moors kurtosis.
}
\examples{
ecp_shape(2, 0.3, 30, measure = 'bowley') # Bowley skewness

}
