% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dormouse_hibernation.R
\docType{data}
\name{dormouse_hibernation}
\alias{dormouse_hibernation}
\title{Dormouse Hibernation and Reproduction Dataset}
\format{
A data frame with 290 rows and 16 variables:
\describe{
\item{animal_id}{Unique identifier for each dormouse}
\item{year_birth}{Year of birth for the animal}
\item{age}{Age of the animal in years}
\item{log_age}{Logarithm of age}
\item{body_mass_before}{Body mass before hibernation (g)}
\item{body_mass_after}{Body mass after hibernation (g)}
\item{hibernation_duration}{Duration of hibernation in days}
\item{hibernation_start}{Date when hibernation started (DD.MM.YY format)}
\item{hibernation_end}{Date when hibernation ended (DD.MM.YY format)}
\item{hibernation_end_year_before}{End date of previous year's hibernation}
\item{body_mass_spring}{Body mass in spring (g)}
\item{year}{Year of observation}
\item{sex}{Sex of the animal (male or female)}
\item{diet}{Diet type (medium, high fat, or protein)}
\item{age_death}{Age at death in years}
\item{repro_active}{Whether the animal was reproductively active (yes or no)}
}
}
\source{
Bieber, Claudia and Turbill, Christopher and Ruf, Thomas (2019). Data from: Effects of aging on timing of hibernation and reproduction. Dryad Digital Repository.
\doi{10.5061/DRYAD.8004G37}
}
\usage{
dormouse_hibernation
}
\description{
This dataset contains hibernation and reproductive data for edible dormice (Glis glis).
The data tracks hibernation patterns, body mass changes, and reproductive activity
across multiple years and individuals. The study examines how age affects hibernation
timing and reproductive behavior in these small hibernating mammals.
}
\details{
The research shows that age strongly affects hibernation/activity patterns through two pathways:
(1) with increasing age, dormice are more likely to reproduce, which delays hibernation onset, and
(2) age directly advances emergence from hibernation in spring. This suggests hibernation
is not merely an energy-saving strategy but an age-affected life-history trait used to maximize fitness.
}
\examples{
\donttest{
# Load the dataset
data(dormouse_hibernation)

# Basic exploration
head(dormouse_hibernation)
summary(dormouse_hibernation)

# Examine hibernation duration by age
boxplot(hibernation_duration ~ age, data = dormouse_hibernation, 
        main = "Hibernation Duration by Age",
        xlab = "Age (years)", ylab = "Duration (days)")
        
# Compare body mass change during hibernation
with(dormouse_hibernation, 
     plot(body_mass_before, body_mass_after, 
          col = as.integer(sex),
          main = "Body Mass Before vs After Hibernation",
          xlab = "Body Mass Before (g)", 
          ylab = "Body Mass After (g)"))
legend("topleft", levels(dormouse_hibernation$sex), 
       col = 1:2, pch = 1)
       
# Examine reproductive activity by age
with(subset(dormouse_hibernation, !is.na(repro_active)), 
     table(age, repro_active))
}
}
\keyword{datasets}
