% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{eastern_bering_sea}
\alias{eastern_bering_sea}
\title{eastern Bering Sea ecosystem data}
\usage{
data(eastern_bering_sea)
}
\description{
Data used to demonstrate a Model of Intermediate Complexity (MICE)
for the eastern Bering Sea.
\code{data(eastern_bering_sea)} loads a list that includes four components:
\itemize{
\item \code{Survey} is a long-form data-frame with three columns, providing the Year,
Mass (in relative units for most taxa, and million metric tons for Pollock,
Cod, Arrowtooth, and NFS), and Taxon for each year with available data
\item \code{Catch} is a long-form data-frame with three columns, providing the Year,
Mass (in million metric tons), and Taxon for each year with available data
\item \code{P_over_B} is a numeric vector with the unitless ratio of biomass production to
population biomass for each taxon (as vector names)
\item \code{Q_over_B} is a numeric vector with the unitless ratio of biomass consumption to
population biomass for each taxon (as vector names)
\item \code{Diet_proportions} is a numeric matrix where each column lists the
proportion of biomass consumed for each predator (column names)
that is provided by each prey (row names)
}
}
\details{
The data compiled come from a variety of sources:
\itemize{
\item Northern fur seal (NFS) survey is an absolute index, corrected for proportion
of time spent in the eastern Bering Sea.  NFS QB is developed from a bioenergetic
model and also corrected for seasonal residency. Both are provided by
Elizabeth McHuron. It is post-processed in a variety of ways, and not
to be treated as an index of abundance for NFS for other uses.
\item Pollock, cod, and arrowtooth surveys are from a bottom trawl survey, and
cod and arrowtooth are treated as an absolute index.
\item Copepod and other zooplankton are from an oblique tow bongo net survey,
with data provided by Dave Kimmel.  It is then post-processed to account
for spatially and seaonally imbalanced data.
\item Other P_over_B, Q_over_B and Diet_proportions values
are derived from Rpath models, provided by Andy Whitehouse.
\item Primary producers is an annual index of relative biomass, developed from monthly
satellite measurements and provided by Jens Nielsen.
See Thorson et al. (2025) for more details regarding data standardization
and sources
}
}
\keyword{data}
