% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{add_population_density_column}
\alias{add_population_density_column}
\title{Add Population Density Column to Country Data}
\usage{
add_population_density_column(
  df,
  id_column,
  id_type = "iso3_code",
  date_column = NULL,
  target_column = "population_density"
)
}
\arguments{
\item{df}{A data frame containing country identifiers.}

\item{id_column}{Name of the column containing country identifiers.}

\item{id_type}{Type of country identifier. Defaults to "iso3_code".}

\item{date_column}{Optional. Name of the column containing dates for
time-specific data.}

\item{target_column}{Name of the output column. Defaults to
"population_density".}
}
\value{
A data frame with an additional column containing population density
data.
}
\description{
Add Population Density Column to Country Data
}
\examples{
\dontshow{if (curl::has_internet()) withAutoprint(\{ # examplesIf}
\donttest{
# Add population density using ISO3 codes
df <- data.frame(country = c("FRA", "DEU", "ESP"))
result <- add_population_density_column(df, id_column = "country")

# Add population density with year
df <- data.frame(country = c("FRA", "DEU"), year = c(2015, 2020))
result <- add_population_density_column(
  df, id_column = "country", date_column = "year"
)
}
\dontshow{\}) # examplesIf}
}
