% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance.R
\name{distance}
\alias{distance}
\title{Distance}
\usage{
distance(balassa_index, proximity_product)
}
\arguments{
\item{balassa_index}{(Type: matrix) the output from
\code{balassa_index()}) or an equivalent arrangement.}

\item{proximity_product}{(Type: matrix) the output from
\code{proximity()}) or an equivalent arrangement.}
}
\value{
A matrix.
}
\description{
\code{distance()} computes the distance matrix that
accounts for the weighted proportions of the products connected to
each good that the countries are not exporting.
}
\details{
The current implementation follows
\insertCite{atlas2014}{economiccomplexity} to measure the oppotunities
implied by a country's position.
}
\examples{
d <- distance(
  economiccomplexity_output$balassa_index,
  economiccomplexity_output$proximity$proximity_product
)

# partial view of the distance matrix
n <- seq_len(5)
d[n, n]

}
\references{
For more information on this index see:

\insertRef{atlas2014}{economiccomplexity}

and the references therein.
}
\keyword{functions}
