% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-fable.R
\name{glance.ESN}
\alias{glance.ESN}
\title{Summary of trained models during random search}
\usage{
\method{glance}{ESN}(x, ...)
}
\arguments{
\item{x}{An object of class \code{mdl_df}, containing an ESN model.}

\item{...}{Currently not in use.}
}
\value{
Summary statistics extracted from the object.
}
\description{
Return summary statistics from trained ESN models during random 
  search as \code{tibble}.
 \itemize{
   \item{\code{model}: Model identifier.}
   \item{\code{loglik}: Log-likelihood.}
   \item{\code{nobs}: Number of observations.}
   \item{\code{df}: Effective degrees of freedom.}
   \item{\code{lambda}: Regularization parameter.}
   \item{\code{aic}: Akaike Information Criterion.}
   \item{\code{aicc}: Corrected Akaike Information Criterion.}
   \item{\code{bic}: Bayesian Information Criterion.}
   \item{\code{hqc}: Hannan-Quinn Information Criterion.}
   \item{\code{mse}: Mean Squared Error.}
   \item{\code{mae}: Mean Absolute Error.}
      }
}
\examples{
library(tsibble)
library(fable)
AirPassengers \%>\%
as_tsibble() \%>\%
model("ESN" = ESN(value)) \%>\%
glance()

}
