% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-fable.R
\name{ESN}
\alias{ESN}
\title{Train an Echo State Network}
\usage{
ESN(formula, ...)
}
\arguments{
\item{formula}{Model specification (currently not in use).}

\item{...}{Further arguments passed to \code{train_esn()}.}
}
\value{
An object of class \code{ESN}.
}
\description{
Train an Echo State Network (ESN) to a univariate time series. 
   The function automatically manages data pre-processing, reservoir
   generation (i.e., internal states) and model estimation and selection. 
   The function is a wrapper for \code{train_esn()} and intended to be used 
   in combination with \code{fabletools::model()}.
}
\examples{
library(tsibble)
library(fable)
AirPassengers \%>\%
as_tsibble() \%>\%
model("ESN" = ESN(value))

}
