% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epm_classes_and_methods.R
\name{get_epm_raw}
\alias{get_epm_raw}
\title{Get Raw Data from an easyPubMed Object.}
\usage{
get_epm_raw(x)
}
\arguments{
\item{x}{An `easyPubMed` object.}
}
\value{
a list including raw data from an `easyPubMed` object.
}
\description{
Request Raw Data from an `easyPubMed` object. This is a wrapper
function that calls the `getEPMRaw()` method. This function returns contents 
from the `raw` slot.
}
\examples{
# Note: a time limit can be set in order to kill the operation when/if 
# the NCBI/Entrez server becomes unresponsive.
setTimeLimit(elapsed = 4.9)
try({
  x <- epm_query(query_string = 'Damiano Fantini[AU] AND "2018"[PDAT]')
  x <- epm_fetch(x)
  get_epm_raw(x)
}, silent = TRUE)
setTimeLimit(elapsed = Inf)

 
}
\references{
\url{https://www.data-pulse.com/dev_site/easypubmed/}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
