% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epm_all_fx.R
\name{EPM_auth_parse}
\alias{EPM_auth_parse}
\title{Parse and Format Author Names and Affiliations.}
\usage{
EPM_auth_parse(x, max_authors = 15, autofill = TRUE)
}
\arguments{
\item{x}{String (character vector of length 1) including an XML Author List
section from a PubMed record.}

\item{max_authors}{Numeric, maximum number of authors to include. See 
details for additional information.}

\item{autofill}{Logical, shall non-missing address information be propagated 
to fill missing address information for other authors 
in the same publication.}
}
\value{
list including 2 elements: `authors` is a data.frame 
including one row for each author and n=4 columns:
lastname, forename, address and email; `collapsed` is a list
including 2 elements (each element is a string): authors and address.
}
\description{
Extract Author Information form a slice of a raw XML PubMed record. 
Last Name, First Name, Address and emails are returned. Only the first
address of each author is returned. A collapsed version of the
author list is also returned.
}
\details{
The value of the `max_authors` argument should be tuned to control which 
author information to extract from the input. If 
`max_authors` is set to `0`, no author information are extracted. If 
`max_authors` is set to `-1` (or any negative number), only information
corresponding to the last author are extracted. If `max_authors` is set to 
`+1`, only the first author information are extracted. If `max_authors`
is set to any other positive integer, only information for the 
indicated number of authors is extracted. In this case, information for both 
the first and the last author will be included.
}
\examples{
aff <- paste0('<Author><LastName>Doe</LastName><ForeName>John</ForeName>', 
              '<Affiliation>Univ A</Affiliation></Author>',
              '<Author><LastName>Doe</LastName><ForeName>Jane</ForeName>', 
              '<Affiliation>jane_doe@univ_a.edu</Affiliation></Author>',
              '<Author><LastName>Foo</LastName><ForeName>Bar</ForeName>', 
              '<Affiliation>Univ B</Affiliation></Author>')
easyPubMed:::EPM_auth_parse(aff)



}
\references{
\url{https://www.data-pulse.com/dev_site/easypubmed/}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
\keyword{internal}
