% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abc_posterior.R
\name{abc_posterior_bootstrap}
\alias{abc_posterior_bootstrap}
\title{Bootstrap resample ABC posterior samples}
\usage{
abc_posterior_bootstrap(abc_result, n_samples, replace = TRUE)
}
\arguments{
\item{abc_result}{An abc object from \code{\link[abc]{abc}}}

\item{n_samples}{Number of bootstrap samples to draw (default 1000)}

\item{replace}{Logical, whether to sample with replacement (default TRUE)}
}
\value{
Data frame of bootstrapped parameter values
}
\description{
Bootstrap resample ABC posterior samples
}
\examples{
# Load an example abc output, you should generate it by applying ABC to your data
# check abc::abc for details on fitting ABC models
rdm_minimal_example <- system.file("extdata", "rdm_minimal", package = "eam")
abc_model <- readRDS(file.path(rdm_minimal_example, "abc", "abc_neuralnet_model.rds"))

# Bootstrap resample posterior parameters
posterior_params <- abc_posterior_bootstrap(
  abc_model,
  n_samples = 100
)

# View the first few rows of the bootstrapped posterior parameters
head(posterior_params)
}
