% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semantic_enrich.R
\name{metavariable_variable_descendants}
\alias{metavariable_variable_descendants}
\title{Extract metavariables' descendant variables}
\usage{
metavariable_variable_descendants(metavariable_info_output)
}
\arguments{
\item{metavariable_info_output}{Output tibble of
\code{\link{metavariable_info}}}
}
\value{
A tibble describing each metavariable, its
  information content, and its descendant variables
}
\description{
Formats the output of \code{\link{metavariable_info}} for easier
interpretation of each metavariable's descendant variables
}
\details{
Not part of the standard semantic enrichment pipeline as this function just
produces a simplified version of the output of \code{\link{metavariable_info}}.

The output of \code{\link{metavariable_info}} is converted to a tibble,
filtered to only include metavariables with highest information content for
the variable set. The tibble has three columns describing a metavariable, its
information content, and its descendant variables.
}
\examples{
data(example_ontology)
require(magrittr)
example_ontology \%>\%
join_vars_to_ontol(example_mapping_file, root = "root") -> joined_ontol

mv_info <- metavariable_info(joined_ontol)
metavariable_variable_descendants(mv_info)
}
\seealso{
\code{\link{node_IC_zhou}}

Other semantic enrichment functions: 
\code{\link{join_vars_to_ontol}()},
\code{\link{metavariable_agg}()},
\code{\link{metavariable_info}()}
}
\concept{semantic enrichment functions}
