% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_models.R
\name{combine_models}
\alias{combine_models}
\title{Combine multiple dyngen models}
\usage{
combine_models(models, duplicate_gold_standard = TRUE)
}
\arguments{
\item{models}{A named list of models. The names of the list will be used to
prefix the different cellular states in the combined model.}

\item{duplicate_gold_standard}{Whether or not the gold standards of the models are
different and should be duplicated and prefixed.}
}
\value{
A combined dyngen model.
}
\description{
Assume the given models have the exact same feature ids and ran up until the \code{generate_cells()} step.
In addition, the user is expected to run \code{generate_experiment()} on the combined models.
}
\details{
See the \href{https://dyngen.dynverse.org/articles/advanced_topics/simulating_knockouts.html}{vignette on simulating batch effects} on how to use this function.
}
\examples{
\donttest{
data("example_model")
model_ab <- combine_models(list("left" = example_model, "right" = example_model))

# show a dimensionality reduction
plot_simulations(model_ab)
plot_gold_mappings(model_ab, do_facet = FALSE)
}
}
