% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duckdb_config.R
\name{duckdb_s3_config}
\alias{duckdb_s3_config}
\title{Configure S3 settings for database connection}
\usage{
duckdb_s3_config(
  conn = cached_connection(),
  s3_access_key_id = NULL,
  s3_secret_access_key = NULL,
  s3_endpoint = NULL,
  s3_region = NULL,
  s3_session_token = NULL,
  s3_uploader_max_filesize = NULL,
  s3_uploader_max_parts_per_file = NULL,
  s3_uploader_thread_limit = NULL,
  s3_url_compatibility_mode = NULL,
  s3_url_style = NULL,
  s3_use_ssl = NULL,
  anonymous = NULL
)
}
\arguments{
\item{conn}{A database connection object created using the
\code{cache_connection} function (default: \code{cache_connection()}).}

\item{s3_access_key_id}{The S3 access key ID (default: \code{NULL}).}

\item{s3_secret_access_key}{The S3 secret access key (default: \code{NULL}).}

\item{s3_endpoint}{The S3 endpoint (default: \code{NULL}).}

\item{s3_region}{The S3 region (default: \code{NULL}).}

\item{s3_session_token}{The S3 session token (default: \code{NULL}).}

\item{s3_uploader_max_filesize}{The maximum filesize for S3 uploader
(between 50GB and 5TB, default 800GB).}

\item{s3_uploader_max_parts_per_file}{The maximum number of parts per file
for S3 uploader (between 1 and 10000, default 10000).}

\item{s3_uploader_thread_limit}{The thread limit for S3 uploader
(default: 50).}

\item{s3_url_compatibility_mode}{Disable Globs and Query Parameters on
S3 URLs (default: 0, allows globs/queries).}

\item{s3_url_style}{The style of S3 URLs to use. Default is
"vhost" unless s3_endpoint is set, which makes default "path"
(i.e. MINIO systems).}

\item{s3_use_ssl}{Enable or disable SSL for S3 connections
(default: 1 (TRUE)).}

\item{anonymous}{request anonymous access (sets \code{s3_access_key_id} and
\code{s3_secret_access_key} to \code{""}, allowing anonymous access to public buckets).}
}
\value{
Returns silently (NULL) if successful.
}
\description{
This function is used to configure S3 settings for a database connection.
It allows you to set various S3-related parameters such as access key,
secret access key, endpoint, region, session token, uploader settings,
URL compatibility mode, URL style, and SSL usage.
}
\details{
see \url{https://duckdb.org/docs/sql/configuration.html}
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
# Configure S3 settings
duckdb_s3_config(
           s3_access_key_id = "YOUR_ACCESS_KEY_ID",
           s3_secret_access_key = "YOUR_SECRET_ACCESS_KEY",
           s3_endpoint = "YOUR_S3_ENDPOINT",
           s3_region = "YOUR_S3_REGION",
           s3_uploader_max_filesize = "800GB",
           s3_uploader_max_parts_per_file = 100,
           s3_uploader_thread_limit = 8,
           s3_url_compatibility_mode = FALSE,
           s3_url_style = "vhost",
           s3_use_ssl = TRUE,
           anonymous = TRUE)
\dontshow{\}) # examplesIf}
}
