% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectra.R
\name{cen_xy}
\alias{cen_xy}
\alias{cen2xy}
\alias{xy2cen}
\title{xy <-> cen}
\usage{
cen2xy(cen)

xy2cen(xy)
}
\arguments{
\item{cen}{the centre of mass of a wavelet spectrum (rho, phi, z), output of \code{dt2cen}}

\item{xy}{the centre of mass in cartesian coordinates (x, y, z), output of cen2xy}
}
\description{
Translate the centre of mass back and forth between polar and cartesian coordinates.
}
\details{
These functions allow you to translate back and forth between the two coordinate systems. \code{dt2cen} represents the sepctrum's centre in cylinder coordinates because that is more intuitive than the x-y-z position within the hexagonal geometry. If you want to compare two spectra, it makes more sense to consider their distance in terms of x1-x2, y1-y2 since the difference in angle is only meaningful for reasonably large radii.
}
\note{
\code{cen2xy} is not the same thing as \code{cen2uv} !
}
\seealso{
\code{\link{dt2cen}}, \code{\link{cen2uv}}
}
