% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-downs.mi.R
\docType{data}
\name{downs.mi}
\alias{downs.mi}
\title{Downs' syndrome cases and of total live births
by maternal age and birth order, Michigan, 1950-1964.}
\format{
This \code{data.frame} contains the following columns:
\describe{
\item{\code{Age}}{The age category of the mothers.}
\item{\code{BirthOrder}}{The birth order.}
\item{\code{Cases}}{The number of cases of Down's Syndrome.}
\item{\code{Births}}{The number of live births.}
\item{\code{Standard}}{A "standard" population, derived as the total
number of births in each age category}
}
}
\source{
The data were obtained from table 14.4 (p 249) in

Fleiss, JL (1981) \emph{Statistical Methods for Rates and Proportions},
Wiley, New York.

The original study is

Stark CR and Mantel N (1966) 'Effects of maternal age and
birth order on the risk of mongolism and leukemia'
\emph{J Natl Cancer Inst} \strong{37} (5) 687--698. \doi{doi:10.1093/jnci/37.5.687}
}
\usage{
downs.mi
}
\description{
This data reproduces table 14.4 in Fleiss (1981) and which is
drawn from a large-scale study in Michigan 1950-1964 of the effect
of Maternal age and Birth order on Down Syndrome and Leukemia
(Stark and Mantell, 1966).
}
\keyword{datasets}
