% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abco.R
\name{t_sampleLogVols}
\alias{t_sampleLogVols}
\title{Sample the latent log-volatilities}
\usage{
t_sampleLogVols(
  h_y,
  h_prev,
  h_mu,
  h_phi,
  h_phi2,
  h_sigma_eta_t,
  h_sigma_eta_0,
  h_st,
  loc
)
}
\arguments{
\item{h_y}{the \code{T } vector of data, which follow independent SV models}

\item{h_prev}{the \code{T} vector of the previous log-vols}

\item{h_mu}{the \code{1} vector of log-vol unconditional means}

\item{h_phi}{the \code{1} vector of log-vol AR(1) coefficients}

\item{h_phi2}{the \code{1} vector of previous penalty coefficient(s)}

\item{h_sigma_eta_t}{the \code{T} vector of log-vol innovation standard deviations}

\item{h_sigma_eta_0}{the \code{1} vector of initial log-vol innovation standard deviations}

\item{h_st}{the \code{T} vector of indicators on whether each time-step exceed the estimated threshold}

\item{loc}{list of the row and column indices to fill in the band-sparse matrix in the sampler}
}
\value{
\code{T x p} vector of simulated log-vols
}
\description{
Compute one draw of the log-volatilities using a discrete mixture of Gaussians
approximation to the likelihood (see Omori, Chib, Shephard, and Nakajima, 2007)
where the log-vols are assumed to follow an TAR(1) model with time-dependent
innovation variances. More generally, the code operates for \code{p} independent
TAR(1) log-vol processes to produce an efficient joint sampler in \code{O(Tp)} time.
}
\note{
For Bayesian trend filtering, \code{p = 1}. More generally, the sampler allows for
\code{p > 1} but assumes (contemporaneous) independence across the log-vols for \code{j = 1,...,p}.
}
