% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/component_samplers.R
\name{sampleLogVols}
\alias{sampleLogVols}
\title{Sample the latent log-volatilities}
\usage{
sampleLogVols(
  h_y,
  h_prev,
  h_mu,
  h_phi,
  h_sigma_eta_t,
  h_sigma_eta_0,
  loc = NULL
)
}
\arguments{
\item{h_y}{the \code{T x p} matrix of data, which follow independent SV models}

\item{h_prev}{the \code{T x p} matrix of the previous log-vols}

\item{h_mu}{the \code{p x 1} vector of log-vol unconditional means}

\item{h_phi}{the \code{p x 1} vector of log-vol AR(1) coefficients}

\item{h_sigma_eta_t}{the \code{T x p} matrix of log-vol innovation standard deviations}

\item{h_sigma_eta_0}{the \code{p x 1} vector of initial log-vol innovation standard deviations}

\item{loc}{list of the row and column indices to fill in a band-sparse matrix}
}
\value{
\code{T x p} matrix of simulated log-vols
}
\description{
Compute one draw of the log-volatilities using a discrete mixture of Gaussians
approximation to the likelihood (see Omori, Chib, Shephard, and Nakajima, 2007)
where the log-vols are assumed to follow an AR(1) model with time-dependent
innovation variances. More generally, the code operates for \code{p} independent
AR(1) log-vol processes to produce an efficient joint sampler in \code{O(Tp)} time.
}
\note{
For Bayesian trend filtering, \code{p = 1}. More generally, the sampler allows for
\code{p > 1} but assumes (contemporaneous) independence across the log-vols for \code{j = 1,...,p}.
}
