% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/component_samplers.R
\name{sampleBTF_sparse}
\alias{sampleBTF_sparse}
\title{Sampler for first or second order random walk (RW) Gaussian dynamic linear model (DLM)
with additional shrinkage to zero}
\usage{
sampleBTF_sparse(
  y,
  obs_sigma_t2,
  evol_sigma_t2,
  zero_sigma_t2,
  D = 1,
  chol0 = NULL
)
}
\arguments{
\item{y}{the \code{T x 1} vector of time series observations}

\item{obs_sigma_t2}{the \code{T x 1} vector of observation error variances}

\item{evol_sigma_t2}{the \code{T x 1} vector of evolution error variances}

\item{zero_sigma_t2}{the \code{T x 1} vector of shrink-to-zero variances}

\item{D}{the degree of differencing (one or two)}

\item{chol0}{(optional) the \code{m x m} matrix of initial Cholesky factorization;
if NULL, use the \code{Matrix} package for sampling, otherwise use the \code{spam} package}
}
\value{
\code{T x 1} vector of simulated states
}
\description{
Compute one draw of the \code{T x 1} state variable \code{mu} in a DLM using back-band substitution methods.
This model is equivalent to the Bayesian trend filtering (BTF) model, assuming appropriate
(shrinkage/sparsity) priors for the evolution errors, with an additional shrinkage-to-zero prior.
}
\note{
Missing entries (NAs) are not permitted in \code{y}. Imputation schemes are available.
}
