% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{initEvolParams}
\alias{initEvolParams}
\title{Initialize the evolution error variance parameters}
\usage{
initEvolParams(omega, evol_error = "DHS")
}
\arguments{
\item{omega}{\code{T x p} matrix of evolution errors}

\item{evol_error}{the evolution error distribution; must be one of
'DHS' (dynamic horseshoe prior), 'HS' (horseshoe prior), or 'NIG' (normal-inverse-gamma prior)}
}
\value{
List of relevant components: \code{sigma_wt}, the \code{T x p} matrix of evolution standard deviations,
and additional parameters associated with the DHS and HS priors.
}
\description{
Compute initial values for evolution error variance parameters under the various options:
dynamic horseshoe prior ('DHS'), horseshoe prior ('HS'),
Bayesian lasso ('BL'), normal stochastic volatility ('SV'),
or normal-inverse-gamma prior ('NIG').
}
