% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{loo_residuals}
\alias{loo_residuals}
\title{Calculate leave-one-out residuals}
\usage{
loo_residuals(
  object,
  nsim = 100,
  what = c("quantiles", "samples", "loo"),
  track_progress = TRUE,
  ...
)
}
\arguments{
\item{object}{Output from \code{\link{dsem}}}

\item{nsim}{Number of simulations to use if \code{family!="fixed"} for some variable,
such that simulation residuals are required.}

\item{what}{whether to return quantile residuals, or samples from the leave-one-out predictive
distribution of data, or a table of leave-one-out predictions and standard errors for the
latent state}

\item{track_progress}{whether to track runtimes on terminal}

\item{...}{Not used}
}
\value{
A matrix of residuals, with same order and dimensions as argument \code{tsdata}
that was passed to \code{dsem}.
}
\description{
Calculates quantile residuals using the predictive distribution from
a jacknife (i.e., leave-one-out predictive distribution)
}
\details{
Conditional quantile residuals cannot be calculated when using \code{family = "fixed"}, because
state-variables are fixed at available measurements and hence the conditional distribution is a Dirac
delta function.  One alternative is to use leave-one-out residuals, where we calculate the predictive distribution
for each state value when dropping the associated observation, and then either use that as the
predictive distribution, or sample from that predictive distribution and then calculate
a standard quantile distribution for a given non-fixed family.  This appraoch is followed here.
It is currently only implemented when  all variables follow \code{family = "fixed"}, but
could be generalized to a mix of families upon request.
}
