% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds.lspline.R
\name{ds.lspline}
\alias{ds.lspline}
\title{Basis for a piecewise linear spline with meaningful coefficients}
\usage{
ds.lspline(
  x,
  knots = NULL,
  marginal = FALSE,
  names = NULL,
  newobj = NULL,
  datasources = NULL
)
}
\arguments{
\item{x}{the name of the input numeric variable}

\item{knots}{numeric vector of knot positions}

\item{marginal}{logical, how to parametrise the spline, see Details}

\item{names}{character, vector of names for constructed variables}

\item{newobj}{a character string that provides the name for the output 
variable that is stored on the data servers. Default \code{lspline.newobj}.}

\item{datasources}{a list of \code{\link[DSI]{DSConnection-class}} 
objects obtained after login. If the \code{datasources} argument is not specified
the default set of connections will be used: see \code{\link[DSI]{datashield.connections_default}}.}
}
\value{
an object of class "lspline" and "matrix", which its name is specified by the
\code{newobj} argument (or its default name "lspline.newobj"), is assigned on the serverside.
}
\description{
This function is based on the native R function \code{lspline} from the
\code{lspline} package. This function computes the basis of piecewise-linear spline
such that, depending on the argument marginal, the coefficients can be interpreted as
(1) slopes of consecutive spline segments, or (2) slope change at consecutive knots.
}
\details{
If marginal is FALSE (default) the coefficients of the spline correspond to
slopes of the consecutive segments. If it is TRUE the first coefficient correspond to
the slope of the first segment. The consecutive coefficients correspond to the change
in slope as compared to the previous segment.
}
\author{
Demetris Avraam for DataSHIELD Development Team
}
