% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds.log.R
\name{ds.log}
\alias{ds.log}
\title{Computes logarithms in the server-side}
\usage{
ds.log(x = NULL, base = exp(1), newobj = NULL, datasources = NULL)
}
\arguments{
\item{x}{a character string providing the name of a numerical vector.}

\item{base}{a positive number, the base for which logarithms are computed.
Default \code{exp(1)}.}

\item{newobj}{a character string that provides the name for the output variable
that is stored on the server-side. Default \code{log.newobj}.}

\item{datasources}{a list of \code{\link[DSI]{DSConnection-class}} objects obtained after login. 
If the \code{datasources} argument is not specified
the default set of connections will be used: see \code{\link[DSI]{datashield.connections_default}}.}
}
\value{
\code{ds.log} returns a vector for each study of the transformed values for the numeric vector 
specified in the argument \code{x}. The created vectors are stored in the server-side.
}
\description{
Computes the logarithms for a specified numeric vector. 
This function is similar to the R \code{log} function. by default natural logarithms.
}
\details{
Server function called: \code{log}
}
\examples{
\dontrun{

  ## Version 6, for version 5 see the Wiki 
  # Connecting to the Opal servers

  require('DSI')
  require('DSOpal')
  require('dsBaseClient')

  builder <- DSI::newDSLoginBuilder()
  builder$append(server = "study1", 
                 url = "http://192.168.56.100:8080/", 
                 user = "administrator", password = "datashield_test&", 
                 table = "CNSIM.CNSIM1", driver = "OpalDriver")
  builder$append(server = "study2", 
                 url = "http://192.168.56.100:8080/", 
                 user = "administrator", password = "datashield_test&", 
                 table = "CNSIM.CNSIM2", driver = "OpalDriver")
  builder$append(server = "study3",
                 url = "http://192.168.56.100:8080/", 
                 user = "administrator", password = "datashield_test&", 
                 table = "CNSIM.CNSIM3", driver = "OpalDriver")
                 
  logindata <- builder$build()
  
  # Log onto the remote Opal training servers
  connections <- DSI::datashield.login(logins = logindata, assign = TRUE, symbol = "D") 
  
  # Calculating the log value of the 'PM_BMI_CONTINUOUS' variable
  
  ds.log(x = "D$PM_BMI_CONTINUOUS",
         base = exp(2),
         newobj = "log.PM_BMI_CONTINUOUS",
         datasources = connections[1]) #only the first Opal server is used (study1)

  # clear the Datashield R sessions and logout
  datashield.logout(connections) 
}

}
\author{
DataSHIELD Development Team
}
