% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimal_multiple_tte.R
\name{optimal_multiple_tte}
\alias{optimal_multiple_tte}
\title{Optimal phase II/III drug development planning for programs with multiple
time-to-event endpoints}
\usage{
optimal_multiple_tte(
  hr1,
  hr2,
  id1,
  id2,
  n2min,
  n2max,
  stepn2,
  hrgomin,
  hrgomax,
  stephrgo,
  alpha,
  beta,
  c2,
  c3,
  c02,
  c03,
  K = Inf,
  N = Inf,
  S = -Inf,
  b11,
  b21,
  b31,
  b12,
  b22,
  b32,
  steps1 = 1,
  stepm1 = 0.95,
  stepl1 = 0.85,
  rho,
  fixed = TRUE,
  num_cl = 1
)
}
\arguments{
\item{hr1}{assumed true treatment effect on HR scale for endpoint 1 (e.g. OS)}

\item{hr2}{assumed true treatment effect on HR scale for endpoint 2 (e.g. PFS)}

\item{id1}{amount of information for hr1 in terms of number of events}

\item{id2}{amount of information for hr2 in terms of number of events}

\item{n2min}{minimal total sample size in phase II, must be divisible by 3}

\item{n2max}{maximal total sample size in phase II, must be divisible by 3}

\item{stepn2}{stepsize for the optimization over n2, must be divisible by 3}

\item{hrgomin}{minimal threshold value for the go/no-go decision rule}

\item{hrgomax}{maximal threshold value for the go/no-go decision rule}

\item{stephrgo}{step size for the optimization over HRgo}

\item{alpha}{one-sided significance level/family-wise error rate}

\item{beta}{type-II error rate for any pair, i.e. \code{1 - beta} is the (any-pair) power for calculation of the number of events for phase III}

\item{c2}{variable per-patient cost for phase II in 10^5 $.}

\item{c3}{variable per-patient cost for phase III in 10^5 $.}

\item{c02}{fixed cost for phase II in 10^5 $.}

\item{c03}{fixed cost for phase III in 10^5 $.}

\item{K}{constraint on the costs of the program, default: Inf, e.g. no constraint}

\item{N}{constraint on the total expected sample size of the program, default: Inf, e.g. no constraint}

\item{S}{constraint on the expected probability of a successful program, default: -Inf, e.g. no constraint}

\item{b11}{expected gain for effect size category \code{"small"} if endpoint 1 is significant (and endpoint 2 may or may not be significant)}

\item{b21}{expected gain for effect size category \code{"medium"} if endpoint 1 is significant (and endpoint 2 may or may not be significant)}

\item{b31}{expected gain for effect size category \code{"large"} if endpoint 1 is significant (and endpoint 2 may or may not be significant)}

\item{b12}{expected gain for effect size category \code{"small"} if endpoint 1 is not significant, but endpoint 2 is}

\item{b22}{expected gain for effect size category \code{"medium"}if endpoint 1 is not significant, but endpoint 2 is}

\item{b32}{expected gain for effect size category \code{"large"} if endpoint 1 is not significant, but endpoint 2 is}

\item{steps1}{lower boundary for effect size category "small" in HR scale, default: 1}

\item{stepm1}{lower boundary for effect size category "medium" in HR scale = upper boundary for effect size category "small" in HR scale, default: 0.95}

\item{stepl1}{lower boundary for effect size category "large" in HR scale = upper boundary for effect size category "medium" in HR scale, default: 0.85}

\item{rho}{correlation between the two endpoints}

\item{fixed}{assumed fixed treatment effect}

\item{num_cl}{number of clusters used for parallel computing, default: 1}
}
\value{
The output of the function is a \code{data.frame} object containing the optimization results:
\describe{\item{OP}{probability that one endpoint is significant}\item{u}{maximal expected utility under the optimization constraints, i.e. the expected utility of the optimal sample size and threshold value}\item{HRgo}{optimal threshold value for the decision rule to go to phase III}
\item{d2}{optimal total number of events for phase II}
\item{d3}{total expected number of events for phase III; rounded to next natural number}
\item{d}{total expected number of events in the program; d = d2 + d3}\item{n2}{total sample size for phase II; rounded to the next even natural number}
\item{n3}{total sample size for phase III; rounded to the next even natural number}
\item{n}{total sample size in the program; n = n2 + n3}
\item{K}{maximal costs of the program (i.e. the cost constraint, if it is set or the sum K2+K3 if no cost constraint is set)}
\item{pgo}{probability to go to phase III}
\item{sProg}{probability of a successful program}\item{sProg1}{probability of a successful program with "small" treatment effect in phase III}
\item{sProg2}{probability of a successful program with "medium" treatment effect in phase III}
\item{sProg3}{probability of a successful program with "large" treatment effect in phase III}\item{K2}{expected costs for phase II}
\item{K3}{expected costs for phase III}}
and further input parameters. Taking \code{cat(comment())} of the
data frame lists the used optimization sequences, start and
finish time of the optimization procedure. The attribute
\code{attr(,"trace")} returns the utility values of all parameter
combinations visited during optimization.
}
\description{
The function \code{\link{optimal_multiple_tte}} of the drugdevelopR package
enables planning of phase II/III drug development programs with optimal
sample size allocation and go/no-go decision rules (Preussler et. al, 2019)
in a two-arm trial with two time-to-event endpoints.
}
\details{
In this setting, the drug development program is defined to be successful if
it proceeds from phase II to phase III and at least one endpoint shows a
statistically significant treatment effect in phase III. For example,
this situation is found in oncology trials, where overall survival (OS)
and progression-free survival (PFS) are the two endpoints of interest.

The gain of a successful program may differ according to the importance of
the endpoint that is significant. If endpoint 1 is significant (no matter
whether endpoint 2 is significant or not), then the gains \code{b11}, \code{b21}
and \code{b31} will be used for calculation of the utility. If only endpoint 2
is significant, then  \code{b12}, \code{b22} and \code{b32} will be used. This
also matches the oncology example, where OS (i.e. endpoint 1) implicates
larger expected gains than PFS alone (i.e. endpoint 2).

Fast computing is enabled by parallel programming.

Monte Carlo simulations are applied for calculating utility, event count and
other operating characteristics in this setting. Hence, the results are affected
by random uncertainty. The extent of uncertainty is discussed in
(Kieser et al. 2018).
}
\examples{
# Activate progress bar (optional)
\dontrun{progressr::handlers(global = TRUE)}
# Optimize
\donttest{
set.seed(123) # This function relies on Monte Carlo integration
optimal_multiple_tte(hr1 = 0.75,
  hr2 = 0.80, id1 = 210, id2 = 420,          # define assumed true HRs
  n2min = 30, n2max = 90, stepn2 = 6,        # define optimization set for n2
  hrgomin = 0.7, hrgomax = 0.9, stephrgo = 0.05, # define optimization set for HRgo
  alpha = 0.025, beta = 0.1,                 # drug development planning parameters
  c2 = 0.75, c3 = 1, c02 = 100, c03 = 150,   # fixed/variable costs for phase II/III
  K = Inf, N = Inf, S = -Inf,                # set constraints
  steps1 = 1,                                # define lower boundary for "small"
  stepm1 = 0.95,                             # "medium"
  stepl1 = 0.85,                             # and "large" effect size categories
  b11 = 1000, b21 = 2000, b31 = 3000,
  b12 = 1000, b22 = 1500, b32 = 2000,        # define expected benefits (both scenarios)
  rho = 0.6, fixed = TRUE,                   # correlation and treatment effect
  num_cl = 1)                                # number of cores for parallelized computing
 }

}
\references{
Kieser, M., Kirchner, M. Dölger, E., Götte, H. (2018).Optimal planning of phase II/III programs for clinical trials with multiple endpoints, Pharm Stat. 2018 Sep; 17(5):437-457.

Preussler, S., Kirchner, M., Goette, H., Kieser, M. (2019). Optimal Designs for Multi-Arm Phase II/III Drug Development Programs. Submitted to peer-review journal.

IQWiG (2016). Allgemeine Methoden. Version 5.0, 10.07.2016, Technical Report. Available at \href{https://www.iqwig.de/ueber-uns/methoden/methodenpapier/}{https://www.iqwig.de/ueber-uns/methoden/methodenpapier/}, assessed last 15.05.19.
}
