% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimal_multiarm.R
\name{optimal_multiarm}
\alias{optimal_multiarm}
\title{Optimal phase II/III drug development planning for multi-arm programs with
time-to-event endpoint}
\usage{
optimal_multiarm(
  hr1,
  hr2,
  ec,
  n2min,
  n2max,
  stepn2,
  hrgomin,
  hrgomax,
  stephrgo,
  alpha,
  beta,
  c2,
  c3,
  c02,
  c03,
  K = Inf,
  N = Inf,
  S = -Inf,
  steps1 = 1,
  stepm1 = 0.95,
  stepl1 = 0.85,
  b1,
  b2,
  b3,
  strategy,
  num_cl = 1
)
}
\arguments{
\item{hr1}{assumed true treatment effect on HR scale for treatment 1}

\item{hr2}{assumed true treatment effect on HR scale for treatment 2}

\item{ec}{control arm event rate for phase II and III}

\item{n2min}{minimal total sample size in phase II, must be divisible by 3}

\item{n2max}{maximal total sample size in phase II, must be divisible by 3}

\item{stepn2}{stepsize for the optimization over n2, must be divisible by 3}

\item{hrgomin}{minimal threshold value for the go/no-go decision rule}

\item{hrgomax}{maximal threshold value for the go/no-go decision rule}

\item{stephrgo}{step size for the optimization over HRgo}

\item{alpha}{one-sided significance level/family-wise error rate}

\item{beta}{type-II error rate for any pair, i.e. \code{1 - beta} is the
(any-pair) power for calculation of the number of events for phase III}

\item{c2}{variable per-patient cost for phase II}

\item{c3}{variable per-patient cost for phase III}

\item{c02}{fixed cost for phase II}

\item{c03}{fixed cost for phase III}

\item{K}{constraint on the costs of the program, default: \code{Inf}, e.g. no constraint}

\item{N}{constraint on the total expected sample size of the program, default: \code{Inf}, e.g. no constraint}

\item{S}{constraint on the expected probability of a successful program, default: \code{-Inf}, e.g. no constraint}

\item{steps1}{lower boundary for effect size category "small" in HR scale, default: 1}

\item{stepm1}{lower boundary for effect size category "medium" in HR scale = upper boundary for effect size category "small" in HR scale, default: 0.95}

\item{stepl1}{lower boundary for effect size category "large" in HR scale = upper boundary for effect size category "medium" in HR scale, default: 0.85}

\item{b1}{expected gain for effect size category "small"}

\item{b2}{expected gain for effect size category "medium"}

\item{b3}{expected gain for effect size category "large"}

\item{strategy}{choose strategy: 1 (only the best promising candidate), 2 (all promising candidates) or 3 (both strategies)}

\item{num_cl}{number of clusters used for parallel computing, default: 1}
}
\value{
The output of the function is a \code{data.frame} object containing the optimization results:
\describe{\item{Strategy}{Strategy, 1: "only best promising" or 2: "all promising"}\item{u}{maximal expected utility under the optimization constraints, i.e. the expected utility of the optimal sample size and threshold value}\item{HRgo}{optimal threshold value for the decision rule to go to phase III}
\item{d2}{optimal total number of events for phase II}
\item{d3}{total expected number of events for phase III; rounded to next natural number}
\item{d}{total expected number of events in the program; d = d2 + d3}\item{n2}{total sample size for phase II; rounded to the next even natural number}
\item{n3}{total sample size for phase III; rounded to the next even natural number}
\item{n}{total sample size in the program; n = n2 + n3}
\item{K}{maximal costs of the program (i.e. the cost constraint, if it is set or the sum K2+K3 if no cost constraint is set)}
\item{pgo}{probability to go to phase III}
\item{sProg}{probability of a successful program}\item{sProg2}{probability of a successful program with two arms in phase III}
\item{sProg3}{probability of a successful program with three arms in phase III}\item{K2}{expected costs for phase II}
\item{K3}{expected costs for phase III}}
and further input parameters. Taking \code{cat(comment())} of the
data frame lists the used optimization sequences, start and
finish time of the optimization procedure. The attribute
\code{attr(,"trace")} returns the utility values of all parameter
combinations visited during optimization.
}
\description{
The function \code{\link{optimal_multiarm}} of the drugdevelopR package
enables planning of multi-arm phase II/III drug development programs with
optimal sample size allocation and go/no-go decision rules
(Preussler et. al, 2019) for time-to-event endpoints. So far, only three-arm
trials with two treatments and one control are supported. The assumed true
treatment effects are assumed fixed (planning is also possible via
user-friendly R Shiny App:
\href{https://web.imbi.uni-heidelberg.de/multiarm/}{multiarm}). Fast
computing is enabled by parallel programming.
}
\examples{
# Activate progress bar (optional)
\dontrun{progressr::handlers(global = TRUE)}
# Optimize
\donttest{
optimal_multiarm(hr1 = 0.75, hr2 = 0.80,    # define assumed true HRs 
  ec = 0.6,                                          # control arm event rate
  n2min = 30, n2max = 90, stepn2 = 6,                # define optimization set for n2
  hrgomin = 0.7, hrgomax = 0.9, stephrgo = 0.05,     # define optimization set for HRgo
  alpha = 0.025, beta = 0.1,                         # drug development planning parameters
  c2 = 0.75, c3 = 1, c02 = 100, c03 = 150,           # fixed/variable costs for phase II/III
  K = Inf, N = Inf, S = -Inf,                        # set constraints
  steps1 = 1,                                        # define lower boundary for "small"
  stepm1 = 0.95,                                     # "medium"
  stepl1 = 0.85,                                     # and "large" effect size categories
  b1 = 1000, b2 = 2000, b3 = 3000,                   # define expected benefit 
  strategy = 1,                                      # choose strategy: 1, 2 or 3
  num_cl = 1)                                        # number of cores for parallelized computing 
  }

}
\references{
Preussler, S., Kirchner, M., Goette, H., Kieser, M. (2019). Optimal Designs for Multi-Arm Phase II/III Drug Development Programs. Submitted to peer-review journal.

IQWiG (2016). Allgemeine Methoden. Version 5.0, 10.07.2016, Technical Report. Available at \href{https://www.iqwig.de/ueber-uns/methoden/methodenpapier/}{https://www.iqwig.de/ueber-uns/methoden/methodenpapier/}, assessed last 15.05.19.
}
