% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{check}
\alias{check}
\alias{check_dc}
\alias{check_prob}
\title{Work with skill checks' probabilities and DCs}
\usage{
check_dc(roll, p, success = TRUE)

check_prob(roll, dc, success = TRUE)
}
\arguments{
\item{roll}{A roll expression (e.g., \code{2 * d6 + 5}) or a data frame returned
by \code{\link[=r]{r()}}.}

\item{p}{The probability of success/failure of the check (or attack).}

\item{success}{Whether to aim for success (the default) or for failure on
the check (or attack).}

\item{dc}{The difficulty class to beat for a skill check (or the armor class
to beat for an attack).}
}
\value{
A numeric scalar.
}
\description{
These are simple functions that manipulate probabilities and DCs for skill
checks. \code{\link[=check_prob]{check_prob()}} calculates the success/failure probability of a check
with the given DC. \code{\link[=check_dc]{check_dc()}} calculates the required difficulty class so
that a skill check has the given success/failure probability. See below for
more details.
}
\details{
These functions hide the complexities of the \link{roll} family so users
unfamiliar with R's d/p/q/r notation can get quickly up and running
with the package. Since attacks and checks work in the same way (i.e.,
success means rolling a value higher than or equal to a certain threshold),
there are no \verb{attack_*()} functions.

For more details on roll expressions, see \code{\link[=r]{r()}} and the \link{Dice} S4 class.
}
\examples{
# Probability of d20 + 8 passing a DC 15 skill check
check_prob(d20 + 8, 15)

# Probability of d20 + 8 missing an AC 15 attack
check_prob(d20 + 8, 15, success = FALSE)
}
\seealso{
\link{roll}, \code{\link[=r]{r()}}, \link{Dice}.
}
