% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{stationary_distributions}
\alias{stationary_distributions}
\title{Stationary laws for a range of positions between <start> and <end>}
\usage{
stationary_distributions(
  x,
  start = 1,
  end = NULL,
  step = NULL,
  output_file = NULL,
  plot = FALSE
)
}
\arguments{
\item{x}{An object of class \code{dmm}}

\item{start}{Start position :  a positive integer giving the start position along the sequence from which the stationary laws of the DMM should be computed}

\item{end}{End position : a positive integer giving the end position along the sequence until which the stationary laws of the DMM should be computed}

\item{step}{A step (integer)}

\item{output_file}{(Optional) A file containing matrix of stationary laws (e.g, "C:/.../SL.txt")}

\item{plot}{\code{FALSE} (default); \code{TRUE} (display a figure plot of stationary distribution probabilities by position)}
}
\value{
A matrix with positions and stationary laws of states
}
\description{
Stationary laws for a range of positions between <start> and <end>
}
\examples{
data(lambda, package = "drimmR")
dmm <- fitdmm(lambda, 1, 1, c('a','c','g','t'), init.estim = "freq",fit.method="sum")
stationary_distributions(dmm,start=1,end=1000,step=100, plot=TRUE)
}
\references{
\insertRef{BaVe2018}{drimmR}
\insertRef{Ver08}{drimmR}
}
\seealso{
\link[drimmR]{fitdmm}, \link[drimmR]{getStationaryLaw}
}
\author{
Alexandre Seiller
}
