% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertyield.R
\name{yieldconvert}
\alias{yieldconvert}
\title{Convert the yield data of plot into different units}
\usage{
yieldconvert(yield.in.kg, length.of.plot, width.of.plot, choose.convert.to)
}
\arguments{
\item{yield.in.kg}{yield data in kilograms}

\item{length.of.plot}{length of plot in m}

\item{width.of.plot}{width of the plot in m}

\item{choose.convert.to}{0 for qtl/ha, 1 for tonnes/ha, 2 for qtl/acre and 3 for tonnes/acre}
}
\value{
converted yield
}
\description{
The function converts the yield data of plot into qtl/ha, tonnes/ha, qtl/acre or tonnes/acre depending on the option chosen.
}
\examples{
#Convert yield vector obtained from 10m x 5m plot into different forms
yield<-c(10,15,12,16,19,25,30,25,11)
#For converting into qtl/ha
yieldconvert(yield,10,5,0)
#For converting into tonnes/ha
yieldconvert(yield,10,5,1)
#For converting into qtl/acre
yieldconvert(yield,10,5,2)
#For converting into tonnes/acre
yieldconvert(yield,10,5,3)
}
